function makelegend2( filename )

mf_settings;

[CFMAP, cfcmap] = imread( baseimagefile ); 

addpath('D:\Matlab\svg')

fid = svgheader( filename, 330, 80 + 40*length( imagevaluesused) );

svglabels( fid, 5, 15,  'Legend:', 'font-size', 12)        



% % Attempt at aligning the permeability values. Only works with
% monospace font.
maxlength = 0;
for idx = 1 : length( legenditems ),
    curlength = length( legenditems{ idx} );
    if curlength>maxlength,
        maxlength = curlength;
    end
end
for idx = 1 : length( legenditems ),
    curlength = length( legenditems{ idx} );
    legenditems{ idx} = [legenditems{ idx}, repmat(' ', 1, maxlength-curlength + 1) ];
end    


%  Draw legend items
cntr = 1;
ss_count = 0;
for idx = imagevaluesused,
    colourfixedvalue = median( CFMAP( MAP(:) == idx ) ) + 1;    
    
%     line elements:
    if strncmpi( strtrim(legenditems{cntr}), 'slip surface',12 ) | strcmpi( strtrim(legenditems{cntr}), 'fracture') | strcmpi( strtrim(legenditems{cntr}), 'deformation band'),       
        if strcmpi( strtrim(legenditems{cntr}), 'deformation band'), 
            % Deformation band, list perm
            label = [legenditems{cntr},  num2str(permeabilities(cntr)), ' mD' ];
            svglabels( fid, 50, 15 + 20*cntr,  label ,   'font-size', 10, 'font-family', 'Lucida console', 'font-weight', 'bold');
            svgrectangle( fid, 15, 13 + 20*cntr, 30, 2, 'fill', svgrgb2hex( cfcmap( colourfixedvalue,1), cfcmap( colourfixedvalue,2), cfcmap( colourfixedvalue,3) ), 'stroke', 'none');
        else
%             Fracture or slip surface, do not list perm, as it is complicated

            if strncmpi( strtrim(legenditems{cntr}), 'slip surface',12 ),
%                  slip surface of some kind.
                ss_count = ss_count+1;
                if ss_count < 2, %Only print one slip surface label
                    svglabels( fid, 50, 15 + 20*cntr,  'Slip surface', 'font-size', 10, 'font-family', 'Lucida console', 'font-weight', 'bold');
                    svgrectangle( fid, 15, 13 + 20*cntr, 30, 2, 'fill', svgrgb2hex( cfcmap( colourfixedvalue,1), cfcmap( colourfixedvalue,2), cfcmap( colourfixedvalue,3) ), 'stroke', 'none');
                else
%                   Skip this slip surface, and decrease counter, to
%                   prevent a whitespace
                    cntr = cntr - 1;
                end
            else % fracture label
                svglabels( fid, 50, 15 + 20*cntr,  legenditems{cntr}, 'font-size', 10, 'font-family', 'Lucida console', 'font-weight', 'bold')
                svgrectangle( fid, 15, 13 + 20*cntr, 30, 2, 'fill', svgrgb2hex( cfcmap( colourfixedvalue,1), cfcmap( colourfixedvalue,2), cfcmap( colourfixedvalue,3) ), 'stroke', 'none');
            end
        end
    else   % block elements:
        svgrectangle( fid, 15, 5 + 20*cntr, 30, 15, 'fill', svgrgb2hex( cfcmap( colourfixedvalue,1), cfcmap( colourfixedvalue,2), cfcmap( colourfixedvalue,3) ), 'stroke', 'black', 'stroke_width',1 );
        label = [legenditems{cntr},  num2str(permeabilities(cntr)), ' mD' ];
        svglabels( fid, 50, 15 + 20*cntr,  label ,   'font-size', 10, 'font-family', 'Lucida console', 'font-weight', 'bold')
    end
    
    cntr = cntr + 1;
end

svgrectangle( fid, 15, 13 + 20*cntr, 30, 1, 'fill', '#000000', 'stroke', 'none');
svglabels( fid, 50, 15 + 20*cntr,  'Streamline', 'font-size', 10, 'font-family', 'Lucida console', 'font-weight', 'bold')


cntr = cntr + 2;

svglabels( fid, 5, 15 + 20*cntr,  'Boundary conditions:', 'font-size', 12, 'font-family', 'Lucida console', 'font-weight', 'bold')        

cntr = cntr + 1;

svgrectangle( fid, 15, 9 + 20*cntr, 30, 5, 'fill', '#000000', 'stroke', 'none');
svglabels( fid, 50, 15 + 20*cntr,  'Flow', 'font-size', 10, 'font-family', 'Lucida console', 'font-weight', 'bold')

cntr = cntr + 1;

svgrectangle( fid, 15, 9 + 20*cntr, 30, 5, 'fill', '#808080', 'stroke', 'none');
svglabels( fid, 50, 15 + 20*cntr,  'No flow', 'font-size', 10, 'font-family', 'Lucida console', 'font-weight', 'bold')

svgfooter(fid)


